<?php declare(strict_types=1);
defined('MW_PATH') or exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 *
 * @package MailWizz EMA
 * @author MailWizz Development Team <support@mailwizz.com>
 * @link https://www.mailwizz.com/
 * @copyright MailWizz EMA (https://www.mailwizz.com)
 * @license https://www.mailwizz.com/license/
 * @since 1.0
 */

/** @var Controller $controller */
$controller = controller();

/** @var string $pageHeading */
$pageHeading = (string)$controller->getData('pageHeading');

/** @var ArticleCategory $category */
$category = $controller->getData('category');

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->getData()}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->add('renderContent', false)}
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
try {
    hooks()->doAction('before_view_file_content', $viewCollection = new CAttributeCollection([
        'controller'    => $controller,
        'renderContent' => true,
    ]));
} catch (Exception $e) {
}

// and render if allowed
if (!empty($viewCollection) && $viewCollection->itemAt('renderContent')) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables
     * via {@CAttributeCollection $collection->controller->getData()}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->add('renderForm', false)}
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    try {
        hooks()->doAction('before_active_form', $collection = new CAttributeCollection([
            'controller' => $controller,
            'renderForm' => true,
        ]));
    } catch (Exception $e) {
    }

    // and render if allowed
    if (!empty($collection) && $collection->itemAt('renderForm')) {
        /** @var CActiveForm $form */
        $form = $controller->beginWidget('CActiveForm'); ?>
        <div class="box box-primary borderless">
            <div class="box-header">
                <div class="pull-left">
                    <?php BoxHeaderContent::make(BoxHeaderContent::LEFT)
                        ->add('<h3 class="box-title">' . IconHelper::make('glyphicon-book') . html_encode((string)$pageHeading) . '</h3>')
                        ->render(); ?>
                </div>
                <div class="pull-right">
                    <?php BoxHeaderContent::make(BoxHeaderContent::RIGHT)
                        ->addIf(HtmlHelper::accessLink(IconHelper::make('create') . t('app', 'Create new'), ['article_categories/create'], ['class' => 'btn btn-primary btn-flat', 'title' => t('app', 'Create new')]), !$category->getIsNewRecord())
                        ->add(HtmlHelper::accessLink(IconHelper::make('cancel') . t('app', 'Cancel'), ['article_categories/index'], ['class' => 'btn btn-primary btn-flat', 'title' => t('app', 'Cancel')]))
                        ->render(); ?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables
                 * via {@CAttributeCollection $collection->controller->getData()}
                 * @since 1.3.3.1
                 */
                try {
                    hooks()->doAction('before_active_form_fields', new CAttributeCollection([
                        'controller' => $controller,
                        'form'       => $form,
                    ]));
                } catch (Exception $e) {
                } ?>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <?php echo $form->labelEx($category, 'name'); ?>
                            <?php echo $form->textField($category, 'name', $category->fieldDecorator->getHtmlOptions('name', ['data-category-id' => (int)$category->category_id, 'data-slug-url' => createUrl('article_categories/slug')])); ?>
                            <?php echo $form->error($category, 'name'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <?php echo $form->labelEx($category, 'description'); ?>
                            <?php echo $form->textArea($category, 'description', $category->fieldDecorator->getHtmlOptions('description', ['rows' => 5])); ?>
                            <?php echo $form->error($category, 'description'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-5">
                        <div class="form-group">
                            <?php echo $form->labelEx($category, 'parent_id'); ?>
                            <?php echo $form->dropDownList($category, 'parent_id', CMap::mergeArray(['' => t('app', 'Choose')], $category->getRelationalCategoriesArray()), $category->fieldDecorator->getHtmlOptions('name')); ?>
                            <?php echo $form->error($category, 'parent_id'); ?>
                        </div>
                    </div>
                    <div class="col-lg-5 slug-wrapper"<?php if (empty($category->slug)) {
                    echo ' style="display:none"';
                } ?>>
                        <div class="form-group">
                            <?php echo $form->labelEx($category, 'slug'); ?>
                            <?php echo $form->textField($category, 'slug', $category->fieldDecorator->getHtmlOptions('slug')); ?>
                            <?php echo $form->error($category, 'slug'); ?>
                        </div>
                    </div>
                    <div class="col-lg-2">
                        <div class="form-group">
                            <?php echo $form->labelEx($category, 'status'); ?>
                            <?php echo $form->dropDownList($category, 'status', $category->getStatusesArray(), $category->fieldDecorator->getHtmlOptions('status')); ?>
                            <?php echo $form->error($category, 'status'); ?>
                        </div>
                    </div>
                </div>
                <?php
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables
                 * via {@CAttributeCollection $collection->controller->getData()}
                 * @since 1.3.3.1
                 */
                try {
                    hooks()->doAction('after_active_form_fields', new CAttributeCollection([
                        'controller' => $controller,
                        'form'       => $form,
                    ]));
                } catch (Exception $e) {
                } ?>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-flat"><?php echo IconHelper::make('save') . t('app', 'Save changes'); ?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <?php
        try {
            $controller->endWidget();
        } catch (Exception $e) {
        }
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables
     * via {@CAttributeCollection $collection->controller->getData()}
     * @since 1.3.3.1
     */
    try {
        hooks()->doAction('after_active_form', new CAttributeCollection([
            'controller'   => $controller,
            'renderedForm' => !empty($collection) ? $collection->itemAt('renderForm') : false,
        ]));
    } catch (Exception $e) {
    }
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->getData()}
 * @since 1.3.3.1
 */
try {
    hooks()->doAction('after_view_file_content', new CAttributeCollection([
        'controller'      => $controller,
        'renderedContent' => !empty($viewCollection) ? $viewCollection->itemAt('renderContent') : false,
    ]));
} catch (Exception $e) {
}
